/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.process.diagram;

import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.canvas.process.VWDesignerBasePropertyPanel;
import filenet.vw.toolkit.design.canvas.process.diagram.VWActivitySubPropertyPanel;
import filenet.vw.toolkit.design.canvas.process.diagram.VWGenericSubPropertyPanel;
import filenet.vw.toolkit.design.canvas.process.diagram.VWSubmapSubPropertyPanel;
import filenet.vw.toolkit.design.canvas.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.VWStepUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Icon;

class VWDiagramStepPropertyPanel
extends VWDesignerBasePropertyPanel {
    protected VWMapNode m_selectedMapNode = null;
    protected VWGenericSubPropertyPanel m_subPropertyPanel;

    public VWDiagramStepPropertyPanel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
    }

    public void setEnabled(boolean bEnable) {
        super.setEnabled(bEnable);
        if (this.m_subPropertyPanel != null) {
            this.m_subPropertyPanel.setEnabled(bEnable && this.m_selectedMapNode != null);
        }
    }

    public Object getDataObject() {
        return this.m_selectedMapNode;
    }

    public void setDataObject(Object dataObject) {
        try {
            if (dataObject == null || !(dataObject instanceof VWMapNode) || dataObject == this.m_selectedMapNode) {
                return;
            }
            this.m_selectedMapNode = (VWMapNode)dataObject;
            this.displaySubPanel();
            this.setEnabled(this.m_authPropertyData.isCurrentMapEditable());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getDisplayName() {
        String name = this.getToolTip();
        if (name != null) {
            name = this.getFormattedTabName(name);
        }
        return name;
    }

    public String getToolTip() {
        if (this.m_subPropertyPanel != null) {
            return this.m_subPropertyPanel.getDisplayName();
        }
        return null;
    }

    public Icon getIcon() {
        return VWStepUtils.getStepIcon(this.m_selectedMapNode, this.m_authPropertyData.getSessionInfo());
    }

    public void displayHelpPage() {
        if (this.m_subPropertyPanel != null) {
            this.m_subPropertyPanel.displayHelpPage();
        }
    }

    public void releaseReferences() {
        if (this.m_subPropertyPanel != null) {
            this.m_subPropertyPanel.removeAll();
            this.m_subPropertyPanel = null;
        }
        this.m_selectedMapNode = null;
        super.releaseReferences();
    }

    protected void createControls() {
        try {
            this.setLayout(new BorderLayout());
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void displaySubPanel() {
        if (this.m_selectedMapNode == null) {
            return;
        }
        this.m_subPropertyPanel = null;
        switch (VWStepUtils.getStepType(this.m_selectedMapNode)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                String stepType = VWResource.s_stepType.toString(VWResource.s_general);
                this.m_subPropertyPanel = new VWActivitySubPropertyPanel(this.m_authPropertyData, stepType);
                break;
            }
            case 9: 
            case 10: {
                String stepType = VWResource.s_stepType.toString(VWResource.s_submap);
                this.m_subPropertyPanel = new VWSubmapSubPropertyPanel(this.m_authPropertyData, stepType);
                break;
            }
            case 0: {
                String stepType = VWResource.s_stepType.toString(VWResource.s_launch);
                this.m_subPropertyPanel = new VWActivitySubPropertyPanel(this.m_authPropertyData, stepType);
                break;
            }
            case 11: 
            case 12: {
                String stepType = VWResource.s_stepType.toString(VWResource.s_system);
                this.m_subPropertyPanel = new VWGenericSubPropertyPanel(this.m_authPropertyData, stepType);
                break;
            }
            case 13: 
            case 14: {
                String stepType = VWResource.s_stepType.toString(VWResource.s_component);
                this.m_subPropertyPanel = new VWGenericSubPropertyPanel(this.m_authPropertyData, stepType);
                break;
            }
        }
        if (this.m_subPropertyPanel != null) {
            this.removeAll();
            this.m_subPropertyPanel.setSelectedStep(this.m_selectedMapNode);
            this.add((Component)this.m_subPropertyPanel, "Center");
        }
    }
}

